/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.k.KaitoDancingShadowIncreaseLoyaltyUseEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.watchers.common.DamagedPlayerThisCombatWatcher;

class KaitoDancingShadowEffect
extends OneShotEffect {
    KaitoDancingShadowEffect() {
        super(Outcome.Benefit);
        this.setText("you may return one of them to its owner's hand. If you do, you may activate loyalty abilities of Kaito twice this turn rather than only once");
    }

    private KaitoDancingShadowEffect(KaitoDancingShadowEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaitoDancingShadowEffect copy() {
        return new KaitoDancingShadowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent card;
        DamagedPlayerThisCombatWatcher watcher = (DamagedPlayerThisCombatWatcher)game.getState().getWatcher(DamagedPlayerThisCombatWatcher.class);
        if (watcher == null) {
            return false;
        }
        Player damagedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || damagedPlayer == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent();
        filter.add((Predicate)new PermanentReferenceInCollectionPredicate((Collection)watcher.getPermanents(controller.getId(), damagedPlayer.getId())));
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        target.withTargetName("creature to return to hand?");
        if (target.chooseTarget(Outcome.ReturnToHand, source.getControllerId(), source, game) && (card = game.getPermanent(target.getFirstTarget())) != null) {
            controller.moveCards((Card)card, Zone.HAND, source, game);
            KaitoDancingShadowIncreaseLoyaltyUseEffect effect = new KaitoDancingShadowIncreaseLoyaltyUseEffect();
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

