/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.InvertCondition;
import mage.abilities.condition.common.RaidCondition;
import mage.abilities.condition.common.SourceEnteredThisTurnCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.GetEmblemEffect;
import mage.abilities.effects.common.PhaseOutSourceEffect;
import mage.abilities.effects.common.discard.DiscardControllerEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.abilities.hint.common.RaidHint;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.game.command.Emblem;
import mage.game.command.emblems.KaitoShizukiEmblem;
import mage.game.permanent.token.NinjaToken;
import mage.game.permanent.token.Token;
import mage.watchers.Watcher;
import mage.watchers.common.PlayerAttackedWatcher;

public final class KaitoShizuki
extends CardImpl {
    private static final Hint hint = new ConditionHint((Condition)SourceEnteredThisTurnCondition.DID, "This permanent entered the battlefield this turn");
    private static final Condition condition = new InvertCondition((Condition)RaidCondition.instance);

    public KaitoShizuki(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{1}{U}{B}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.KAITO);
        this.setStartingLoyalty(3);
        this.addAbility(new BeginningOfEndStepTriggeredAbility(TargetController.YOU, (Effect)new PhaseOutSourceEffect().setText("he phases out"), false, (Condition)SourceEnteredThisTurnCondition.DID).addHint(hint));
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new DrawCardSourceControllerEffect(1), 1);
        ability.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new DiscardControllerEffect(1), condition, "Then discard a card unless you attacked this turn"));
        this.addAbility(ability.addHint((Hint)RaidHint.instance), (Watcher)new PlayerAttackedWatcher());
        this.addAbility((Ability)new LoyaltyAbility((Effect)new CreateTokenEffect((Token)new NinjaToken()), -2));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new GetEmblemEffect((Emblem)new KaitoShizukiEmblem()), -7));
    }

    private KaitoShizuki(KaitoShizuki card) {
        super((CardImpl)card);
    }

    public KaitoShizuki copy() {
        return new KaitoShizuki(this);
    }
}

