/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;

class KalitasTraitorOfGhetEffect
extends ReplacementEffectImpl {
    KalitasTraitorOfGhetEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a nontoken creature an opponent controls would die, instead exile that card and create a 2/2 black Zombie creature token";
    }

    private KalitasTraitorOfGhetEffect(KalitasTraitorOfGhetEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public KalitasTraitorOfGhetEffect copy() {
        return new KalitasTraitorOfGhetEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && (permanent = ((ZoneChangeEvent)event).getTarget()) != null) {
            controller.moveCards((Card)permanent, Zone.EXILED, source, game);
            new CreateTokenEffect((Token)new ZombieToken()).apply(game, source);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getToZone() == Zone.GRAVEYARD && (permanent = ((ZoneChangeEvent)event).getTarget()) != null && game.getOpponents(source.getControllerId()).contains(permanent.getControllerId()) && !(permanent instanceof PermanentToken) && (zEvent.getTarget() != null ? zEvent.getTarget().isCreature(game) : permanent.isCreature(game));
    }
}

