/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.ControlACommanderCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.k.KamahlsWillEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class KamahlsWill
extends CardImpl {
    public KamahlsWill(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{3}{G}");
        this.getSpellAbility().getModes().setChooseText("Choose one. If you control a commander as you cast this spell, you may choose both.");
        this.getSpellAbility().getModes().setMoreCondition(2, (Condition)ControlACommanderCondition.instance);
        this.getSpellAbility().addEffect((Effect)new BecomesCreatureTargetEffect((Token)new CreatureToken(1, 1, "1/1 Elemental creatures with vigilance, indestructible, and haste").withSubType(SubType.ELEMENTAL).withAbility((Ability)VigilanceAbility.getInstance()).withAbility((Ability)IndestructibleAbility.getInstance()).withAbility((Ability)HasteAbility.getInstance()), false, true, Duration.EndOfTurn).setText("until end of turn, any number of target lands you control become 1/1 Elemental creatures with vigilance, indestructible, and haste. They're still lands"));
        this.getSpellAbility().addTarget((Target)new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LANDS, false));
        Mode mode = new Mode((Effect)new KamahlsWillEffect());
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
        this.getSpellAbility().addMode(mode);
    }

    private KamahlsWill(KamahlsWill card) {
        super((CardImpl)card);
    }

    public KamahlsWill copy() {
        return new KamahlsWill(this);
    }
}

