/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class KamiOfTransienceWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    KamiOfTransienceWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent() || !zEvent.getTarget().isEnchantment(game)) {
            return;
        }
        this.playerSet.add(zEvent.getTarget().getOwnerId());
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    public static boolean checkPlayer(Game game, Ability source) {
        return ((KamiOfTransienceWatcher)game.getState().getWatcher(KamiOfTransienceWatcher.class)).playerSet.contains(source.getControllerId());
    }
}

