/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KamizDoubleStrikeEffect
extends OneShotEffect {
    KamizDoubleStrikeEffect() {
        super(Outcome.AddAbility);
        this.staticText = "choose another attacking creature with lesser power. That creature gains double strike until end of turn";
    }

    private KamizDoubleStrikeEffect(KamizDoubleStrikeEffect effect) {
        super((OneShotEffect)effect);
    }

    public KamizDoubleStrikeEffect copy() {
        return new KamizDoubleStrikeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        FilterAttackingCreature filter = new FilterAttackingCreature("another attacking creature with lesser power");
        filter.add(Predicates.not((Predicate)new PermanentIdPredicate(permanent.getId())));
        filter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, permanent.getPower().getValue()));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        if (target.choose(this.outcome, source.getControllerId(), source.getSourceId(), source, game)) {
            game.addEffect(new GainAbilityTargetEffect((Ability)DoubleStrikeAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game)), source);
        }
        return true;
    }
}

