/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.PowerstoneToken;
import mage.game.permanent.token.PowerstoneTokenManaBuilder;
import mage.players.Player;

class KarnLegacyReforgedEffect
extends OneShotEffect {
    KarnLegacyReforgedEffect() {
        super(Outcome.Benefit);
        this.staticText = "add {C} for each artifact you control. This mana can't be spent to cast nonartifact spells. Until end of turn, you don't lose this mana as steps and phases end";
    }

    private KarnLegacyReforgedEffect(KarnLegacyReforgedEffect effect) {
        super((OneShotEffect)effect);
    }

    public KarnLegacyReforgedEffect copy() {
        return new KarnLegacyReforgedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int artifacts = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT, source.getControllerId(), source, game);
        if (player == null || artifacts < 1) {
            return false;
        }
        PowerstoneTokenManaBuilder builder = PowerstoneToken.makeBuilder();
        builder.setMana(Mana.ColorlessMana((int)artifacts), source, game);
        player.getManaPool().addMana((Mana)builder.build(new Object[0]), game, source, true);
        return true;
    }
}

