/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class KarnPlus1Effect
extends OneShotEffect {
    KarnPlus1Effect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top two cards of your library. An opponent chooses one of them. Put that card into your hand and exile the other with a silver counter on it.";
    }

    private KarnPlus1Effect(KarnPlus1Effect effect) {
        super((OneShotEffect)effect);
    }

    public KarnPlus1Effect copy() {
        return new KarnPlus1Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card cardToHand;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 2));
        if (cards.isEmpty()) {
            return true;
        }
        controller.revealCards(source, (Cards)cards, game);
        switch (cards.size()) {
            case 0: {
                return false;
            }
            case 1: {
                cardToHand = cards.getRandom(game);
                break;
            }
            default: {
                TargetOpponent target;
                Player opponent;
                Set opponents = game.getOpponents(controller.getId());
                if (opponents.size() == 1) {
                    opponent = game.getPlayer((UUID)opponents.iterator().next());
                } else {
                    target = new TargetOpponent(true);
                    controller.chooseTarget(Outcome.Detriment, (Target)target, source, game);
                    opponent = game.getPlayer(target.getFirstTarget());
                }
                target = new TargetCard(1, Zone.LIBRARY, StaticFilters.FILTER_CARD);
                opponent.chooseTarget(this.outcome, (Cards)cards, (TargetCard)target, source, game);
                cardToHand = game.getCard(target.getFirstTarget());
            }
        }
        if (cardToHand != null) {
            controller.moveCards(cardToHand, Zone.HAND, source, game);
        }
        cards.retainZone(Zone.LIBRARY, game);
        if (cards.isEmpty()) {
            return true;
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.getCards(game).stream().forEach(card -> card.addCounters(CounterType.SILVER.createInstance(1), source, game));
        return true;
    }
}

