/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KarnsTouchEffect
extends ContinuousEffectImpl {
    KarnsTouchEffect() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "Target noncreature artifact becomes an artifact creature with power and toughness each equal to its mana value until end of turn";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private KarnsTouchEffect(KarnsTouchEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public KarnsTouchEffect copy() {
        return new KarnsTouchEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent artifact = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (artifact == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                if (sublayer != SubLayer.NA) break;
                if (!artifact.isArtifact(game)) {
                    artifact.addCardType(game, new CardType[]{CardType.ARTIFACT});
                }
                if (artifact.isCreature(game)) break;
                artifact.addCardType(game, new CardType[]{CardType.CREATURE});
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                int cmc = artifact.getManaValue();
                artifact.getPower().setModifiedBaseValue(cmc);
                artifact.getToughness().setModifiedBaseValue(cmc);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.TypeChangingEffects_4;
    }
}

