/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class KaronaFalseGodEffect
extends OneShotEffect {
    KaronaFalseGodEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "creatures of the creature type of your choice get +3/+3 until end of turn";
    }

    private KaronaFalseGodEffect(KaronaFalseGodEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaronaFalseGodEffect copy() {
        return new KaronaFalseGodEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null) {
            ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
            if (!controller.choose(Outcome.BoostCreature, (Choice)typeChoice, game)) {
                return false;
            }
            game.informPlayers(controller.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
            game.addEffect((ContinuousEffect)new BoostAllEffect(3, 3, Duration.EndOfTurn, filter, false), source);
            return true;
        }
        return false;
    }
}

