/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KasetoEffect
extends OneShotEffect {
    KasetoEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Target creature can't be blocked this turn. If that creature is a Snake, it gets +2/+2 until end of turn";
    }

    private KasetoEffect(KasetoEffect effect) {
        super((OneShotEffect)effect);
    }

    public KasetoEffect copy() {
        return new KasetoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            game.addEffect((ContinuousEffect)new CantBeBlockedTargetEffect(Duration.EndOfTurn), source);
            if (permanent.hasSubtype(SubType.SNAKE, game)) {
                game.addEffect((ContinuousEffect)new BoostTargetEffect(2, 2, Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }
}

