/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class KathrilAspectWarperEffect
extends OneShotEffect {
    KathrilAspectWarperEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a flying counter on any creature you control if a creature card in your graveyard has flying. Repeat this process for first strike, double strike, deathtouch, hexproof, indestructible, lifelink, menace, reach, trample, and vigilance. Then put a +1/+1 counter on {this} for each counter put on a creature this way.";
    }

    private KathrilAspectWarperEffect(KathrilAspectWarperEffect effect) {
        super((OneShotEffect)effect);
    }

    public KathrilAspectWarperEffect copy() {
        return new KathrilAspectWarperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game) == 0) {
            return false;
        }
        Set counterSet = player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game).stream().map(MageObject::getAbilities).flatMap(Collection::stream).map(this::checkAbility).collect(Collectors.toSet());
        if (counterSet == null || counterSet.size() == 0) {
            return false;
        }
        int countersAdded = 0;
        for (CounterType counterType : counterSet) {
            Permanent permanent;
            if (counterType == null) continue;
            FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature to give a " + counterType + " counter");
            TargetControlledPermanent target = new TargetControlledPermanent((FilterControlledPermanent)filter);
            target.withNotTarget(true);
            if (!player.choose(this.outcome, (Target)target, source, game) || (permanent = game.getPermanent(target.getFirstTarget())) == null || !permanent.addCounters(counterType.createInstance(), source.getControllerId(), source, game)) continue;
            ++countersAdded;
        }
        if (countersAdded == 0) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return true;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(countersAdded), source.getControllerId(), source, game);
        return true;
    }

    private CounterType checkAbility(Ability ability) {
        if (ability instanceof FlyingAbility) {
            return CounterType.FLYING;
        }
        if (ability instanceof FirstStrikeAbility) {
            return CounterType.FIRST_STRIKE;
        }
        if (ability instanceof DoubleStrikeAbility) {
            return CounterType.DOUBLE_STRIKE;
        }
        if (ability instanceof DeathtouchAbility) {
            return CounterType.DEATHTOUCH;
        }
        if (ability instanceof HexproofBaseAbility) {
            return CounterType.HEXPROOF;
        }
        if (ability instanceof IndestructibleAbility) {
            return CounterType.INDESTRUCTIBLE;
        }
        if (ability instanceof LifelinkAbility) {
            return CounterType.LIFELINK;
        }
        if (ability instanceof MenaceAbility) {
            return CounterType.MENACE;
        }
        if (ability instanceof ReachAbility) {
            return CounterType.REACH;
        }
        if (ability instanceof TrampleAbility) {
            return CounterType.TRAMPLE;
        }
        if (ability instanceof VigilanceAbility) {
            return CounterType.VIGILANCE;
        }
        return null;
    }
}

