/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class KayaOrzhovUsurperExileEffect
extends OneShotEffect {
    KayaOrzhovUsurperExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile up to two target cards from a single graveyard. You gain 2 life if at least one creature card was exiled this way.";
    }

    private KayaOrzhovUsurperExileEffect(KayaOrzhovUsurperExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public KayaOrzhovUsurperExileEffect copy() {
        return new KayaOrzhovUsurperExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Target target : source.getTargets()) {
            for (UUID targetId : target.getTargets()) {
                Card card = game.getCard(targetId);
                if (card == null) continue;
                cards.add(card);
            }
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card : cards.getCards(game)) {
            if (card == null || !card.isCreature(game)) continue;
            player.gainLife(2, game, source);
            break;
        }
        return false;
    }
}

