/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.k.KayaSpiritsJusticeCopyEffect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeBatchEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class KayaSpiritsJusticeTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<ZoneChangeEvent> {
    KayaSpiritsJusticeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new KayaSpiritsJusticeCopyEffect(), false);
        this.setTriggerPhrase("Whenever one or more creatures you control and/or creature cards in your graveyard are put into exile, you may choose a creature card from among them. Until end of turn, target token you control becomes a copy of it, except it has flying.");
    }

    private KayaSpiritsJusticeTriggeredAbility(KayaSpiritsJusticeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public KayaSpiritsJusticeTriggeredAbility copy() {
        return new KayaSpiritsJusticeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_BATCH;
    }

    public boolean checkEvent(ZoneChangeEvent event, Game game) {
        if (event.getToZone() != Zone.EXILED) {
            return false;
        }
        switch (event.getFromZone()) {
            case BATTLEFIELD: {
                Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
                return permanent != null && StaticFilters.FILTER_CONTROLLED_CREATURE.match(permanent, this.getControllerId(), (Ability)this, game);
            }
            case GRAVEYARD: {
                Card card = game.getCard(event.getTargetId());
                return card != null && card.isOwnedBy(this.getControllerId()) && StaticFilters.FILTER_CARD_CREATURE.match(card, this.getControllerId(), (Ability)this, game);
            }
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        CardsImpl cards = new CardsImpl();
        this.getFilteredEvents((BatchEvent)((ZoneChangeBatchEvent)event), game).stream().map(GameEvent::getTargetId).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        if (cards.isEmpty()) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game));
        return true;
    }
}

