/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderYourControlAttachedEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class KayasGhostformTriggeredAbility
extends TriggeredAbilityImpl {
    KayasGhostformTriggeredAbility() {
        super(Zone.ALL, (Effect)new ReturnToBattlefieldUnderYourControlAttachedEffect(), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private KayasGhostformTriggeredAbility(KayasGhostformTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public KayasGhostformTriggeredAbility copy() {
        return new KayasGhostformTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attachedTo;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() != Zone.BATTLEFIELD || zEvent.getToZone() != Zone.GRAVEYARD && zEvent.getToZone() != Zone.EXILED) {
            return false;
        }
        if (zEvent.getTarget() != null && zEvent.getTarget().getAttachments() != null && zEvent.getTarget().getAttachments().contains(this.getSourceId())) {
            ((Effect)this.getEffects().get(0)).setValue("attachedTo", (Object)zEvent.getTarget());
            return true;
        }
        Permanent attachment = game.getPermanentOrLKIBattlefield(this.getSourceId());
        if (attachment != null && zEvent.getTargetId() != null && attachment.getAttachedTo() != null && zEvent.getTargetId().equals(attachment.getAttachedTo()) && (attachedTo = game.getPermanentOrLKIBattlefield(attachment.getAttachedTo())) != null && attachment.getAttachedToZoneChangeCounter() == attachedTo.getZoneChangeCounter(game)) {
            ((Effect)this.getEffects().get(0)).setValue("attachedTo", (Object)attachedTo);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "When enchanted permanent dies or is put into exile, return that card to the battlefield under your control.";
    }
}

