/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.k.KaylasMusicBoxLookEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class KaylasMusicBoxExileEffect
extends OneShotEffect {
    KaylasMusicBoxExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library, then exile it face down";
    }

    private KaylasMusicBoxExileEffect(KaylasMusicBoxExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaylasMusicBoxExileEffect copy() {
        return new KaylasMusicBoxExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        card.setFaceDown(true, game);
        controller.lookAtCards(null, card, game);
        if (controller.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source))) {
            card.setFaceDown(true, game);
            KaylasMusicBoxLookEffect effect = new KaylasMusicBoxLookEffect(controller.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

