/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.cards.k.KazaRoilChaserWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.util.CardUtil;

class KazaRoilChaserEffect
extends CostModificationEffectImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.WIZARD);
    private int spellsCast;
    private int wizardCount = 0;

    KazaRoilChaserEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "the next instant or sorcery spell you cast this turn costs {X} less to cast, where X is the number of Wizards you control as this ability resolves";
    }

    private KazaRoilChaserEffect(KazaRoilChaserEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.spellsCast = effect.spellsCast;
        this.wizardCount = effect.wizardCount;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        KazaRoilChaserWatcher watcher = (KazaRoilChaserWatcher)game.getState().getWatcher(KazaRoilChaserWatcher.class);
        if (watcher != null) {
            this.spellsCast = watcher.getCount(source.getControllerId());
        }
        this.wizardCount = game.getBattlefield().count(filter, source.getControllerId(), source, game);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)this.wizardCount);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        KazaRoilChaserWatcher watcher = (KazaRoilChaserWatcher)game.getState().getWatcher(KazaRoilChaserWatcher.class);
        if (watcher == null) {
            return false;
        }
        if (watcher.getCount(source.getControllerId()) > this.spellsCast) {
            this.discard();
            return false;
        }
        if (!(abilityToModify instanceof SpellAbility) || !abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        Card spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
        return spellCard != null && spellCard.isInstantOrSorcery(game);
    }

    public KazaRoilChaserEffect copy() {
        return new KazaRoilChaserEffect(this);
    }
}

