/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.OgreToken;
import mage.players.Player;

class KazuulTyrantOfTheCliffsEffect
extends OneShotEffect {
    protected Cost cost;
    private static OgreToken token = new OgreToken();

    KazuulTyrantOfTheCliffsEffect(Cost cost) {
        super(Outcome.PutCreatureInPlay);
        this.cost = cost;
    }

    private KazuulTyrantOfTheCliffsEffect(KazuulTyrantOfTheCliffsEffect effect) {
        super((OneShotEffect)effect);
        this.cost = effect.cost.copy();
    }

    public boolean apply(Game game, Ability source) {
        Player payee = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (payee == null) {
            return false;
        }
        this.cost.clearPaid();
        if (this.cost.pay(source, game, source, payee.getId(), false, null)) {
            return false;
        }
        return token.putOntoBattlefield(1, game, source, source.getControllerId());
    }

    public KazuulTyrantOfTheCliffsEffect copy() {
        return new KazuulTyrantOfTheCliffsEffect(this);
    }
}

