/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class KeenDuelistEffect
extends OneShotEffect {
    KeenDuelistEffect() {
        super(Outcome.Benefit);
        this.staticText = "you and target opponent each reveal the top card of your library. You each lose life equal to the mana value of the card revealed by the other player. You each put the card you revealed into your hand";
    }

    private KeenDuelistEffect(KeenDuelistEffect effect) {
        super((OneShotEffect)effect);
    }

    public KeenDuelistEffect copy() {
        return new KeenDuelistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card myCard = controller.getLibrary().getFromTop(game);
        cards.add(myCard);
        Card theirCard = opponent.getLibrary().getFromTop(game);
        cards.add(theirCard);
        controller.revealCards(source, (Cards)cards, game);
        if (theirCard != null && theirCard.getManaValue() > 0) {
            controller.loseLife(theirCard.getManaValue(), game, source, false);
        }
        if (myCard != null && myCard.getManaValue() > 0) {
            opponent.loseLife(myCard.getManaValue(), game, source, false);
        }
        controller.moveCards((Cards)cards, Zone.HAND, source, game);
        return true;
    }
}

