/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class KeenEaredSentryWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    KeenEaredSentryWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.VENTURED) {
            this.playerSet.add(event.getTargetId());
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        KeenEaredSentryWatcher watcher = (KeenEaredSentryWatcher)game.getState().getWatcher(KeenEaredSentryWatcher.class);
        return watcher != null && watcher.playerSet.contains(playerId);
    }
}

