/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KeeperOfDeadPredicate
implements ObjectSourcePlayerPredicate<Player> {
    KeeperOfDeadPredicate() {
    }

    public boolean apply(ObjectSourcePlayer<Player> input, Game game) {
        Player targetPlayer = (Player)input.getObject();
        Permanent sourceObject = input.getSource().getSourcePermanentIfItStillExists(game);
        Player controller = null;
        if (sourceObject != null) {
            controller = game.getPlayer(sourceObject.getControllerId());
        }
        if (targetPlayer == null || controller == null || !controller.hasOpponent(targetPlayer.getId(), game)) {
            return false;
        }
        int countGraveyardTargetPlayer = targetPlayer.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURES, game).size();
        int countGraveyardController = controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURES, game).size();
        return countGraveyardController >= countGraveyardTargetPlayer + 2;
    }

    public String toString() {
        return "opponent who had at least two fewer creature cards in their graveyard than you did as you activated this ability";
    }
}

