/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Set;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class KeeperOfTheDeadCreatureTarget
extends TargetPermanent {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("nonblack creature that player controls");

    public KeeperOfTheDeadCreatureTarget() {
        super(1, 1, (FilterPermanent)filter);
    }

    private KeeperOfTheDeadCreatureTarget(KeeperOfTheDeadCreatureTarget target) {
        super((TargetPermanent)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Player needPlayer = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        if (needPlayer != null) {
            possibleTargets.removeIf(id -> {
                Permanent permanent = game.getPermanent(id);
                return permanent == null || permanent.getId().equals(source.getFirstTarget()) || !permanent.isControlledBy(needPlayer.getId());
            });
        }
        return possibleTargets;
    }

    public KeeperOfTheDeadCreatureTarget copy() {
        return new KeeperOfTheDeadCreatureTarget(this);
    }

    static {
        filter.add(Predicates.not((Predicate)new ColorPredicate(ObjectColor.BLACK)));
    }
}

