/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;

class KeeperOfTheMindPredicate
implements ObjectSourcePlayerPredicate<Player> {
    private final int controllerHandSize;

    KeeperOfTheMindPredicate(int controllerHandSize) {
        this.controllerHandSize = controllerHandSize;
    }

    public boolean apply(ObjectSourcePlayer<Player> input, Game game) {
        Player targetPlayer = (Player)input.getObject();
        if (targetPlayer == null) {
            return false;
        }
        int countHandTargetPlayer = targetPlayer.getHand().size();
        return countHandTargetPlayer - 2 >= this.controllerHandSize;
    }

    public String toString() {
        return "opponent who had at least two more cards in hand than you did as you activated this ability";
    }
}

