/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KellanPlanarTrailblazerRogueEffect
extends OneShotEffect {
    KellanPlanarTrailblazerRogueEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Detective, it becomes a 3/2 Human Faerie Rogue and gains double strike.";
    }

    private KellanPlanarTrailblazerRogueEffect(KellanPlanarTrailblazerRogueEffect effect) {
        super((OneShotEffect)effect);
    }

    public KellanPlanarTrailblazerRogueEffect copy() {
        return new KellanPlanarTrailblazerRogueEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.DETECTIVE, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.Custom, new SubType[]{SubType.HUMAN, SubType.FAERIE, SubType.ROGUE}), source);
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(3, 2, Duration.Custom), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.Custom), source);
        return true;
    }
}

