/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class KellanTheKidEffect
extends OneShotEffect {
    KellanTheKidEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast a permanent spell with equal or lesser mana value from your hand without paying its mana cost. If you don't, you may put a land card from your hand onto the battlefield";
    }

    private KellanTheKidEffect(KellanTheKidEffect effect) {
        super((OneShotEffect)effect);
    }

    public KellanTheKidEffect copy() {
        return new KellanTheKidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (player == null || spell == null) {
            return false;
        }
        FilterPermanentCard filter = new FilterPermanentCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, spell.getManaValue() + 1));
        return CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)player.getHand()), (FilterCard)filter) || new PutCardFromHandOntoBattlefieldEffect((FilterCard)StaticFilters.FILTER_CARD_LAND).apply(game, source);
    }
}

