/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KembasLegionEffect
extends ContinuousEffectImpl {
    KembasLegionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "{this} can block an additional creature each combat for each Equipment attached to {this}";
    }

    private KembasLegionEffect(KembasLegionEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public KembasLegionEffect copy() {
        return new KembasLegionEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && !permanent.getAttachments().isEmpty()) {
            if (layer == Layer.RulesEffects && permanent.getMaxBlocks() > 0) {
                List attachments = permanent.getAttachments();
                int count = 0;
                for (UUID attachmentId : attachments) {
                    Permanent attachment = game.getPermanent(attachmentId);
                    if (attachment == null || !attachment.hasSubtype(SubType.EQUIPMENT, game)) continue;
                    ++count;
                }
                permanent.setMaxBlocks(permanent.getMaxBlocks() + count);
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

