/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class KenessosPriestOfThassaActivatedEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a Kraken, Leviathan, Octopus, or Serpent creature card");

    public KenessosPriestOfThassaActivatedEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Look at the top card of your library. If it's a Kraken, Leviathan, Octopus, or Serpent creature card, you may put it onto the battlefield. If you don't put the card onto the battlefield, you may put it on the bottom of your library.";
    }

    private KenessosPriestOfThassaActivatedEffect(KenessosPriestOfThassaActivatedEffect effect) {
        super((OneShotEffect)effect);
    }

    public KenessosPriestOfThassaActivatedEffect copy() {
        return new KenessosPriestOfThassaActivatedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards(null, card, game);
        if (filter.match(card, game) && player.chooseUse(this.outcome, "Put " + card.getName() + " onto the battlefield?", source, game)) {
            return player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        if (player.chooseUse(this.outcome, "Put " + card.getName() + " on the bottom of your library?", source, game)) {
            return player.putCardsOnBottomOfLibrary(card, game, source);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.KRAKEN.getPredicate(), SubType.LEVIATHAN.getPredicate(), SubType.OCTOPUS.getPredicate(), SubType.SERPENT.getPredicate()}));
    }
}

