/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeBatchEvent;
import mage.game.events.ZoneChangeEvent;

class KetramoseTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<ZoneChangeEvent> {
    KetramoseTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), false);
        this.addEffect((Effect)new LoseLifeSourceControllerEffect(1));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private KetramoseTriggeredAbility(KetramoseTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_BATCH;
    }

    public boolean checkEvent(ZoneChangeEvent event, Game game) {
        if (event.getToZone() != Zone.EXILED) {
            return false;
        }
        return event.getFromZone() == Zone.GRAVEYARD || event.getFromZone() == Zone.BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.getActivePlayerId().equals(this.getControllerId()) && !this.getFilteredEvents((BatchEvent)((ZoneChangeBatchEvent)event), game).isEmpty();
    }

    public TriggeredAbility copy() {
        return new KetramoseTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more cards are put into exile from graveyards and/or the battlefield during your turn, you draw a card and lose 1 life.";
    }
}

