/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.ChooseFriendsAndFoes;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class KhorvathsFuryEffect
extends OneShotEffect {
    KhorvathsFuryEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each player, choose friend or foe. Each friend discards all cards from their hand, then draws that many cards plus one. {this} deals damage to each foe equal to the number of cards in their hand";
    }

    private KhorvathsFuryEffect(KhorvathsFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public KhorvathsFuryEffect copy() {
        return new KhorvathsFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ChooseFriendsAndFoes choice = new ChooseFriendsAndFoes();
        choice.chooseFriendOrFoe(controller, source, game);
        HashMap<UUID, Integer> cardsToDraw = new HashMap<UUID, Integer>();
        for (Player player : choice.getFriends()) {
            int cardsInHand;
            if (player == null || (cardsInHand = player.getHand().size()) <= 0) continue;
            player.discard(cardsInHand, false, false, source, game);
            cardsToDraw.put(player.getId(), cardsInHand);
        }
        for (Player player : choice.getFriends()) {
            if (player == null) continue;
            player.drawCards(cardsToDraw.getOrDefault(player.getId(), 0) + 1, source, game);
        }
        for (Player player : choice.getFoes()) {
            if (player == null) continue;
            player.damage(player.getHand().size(), source.getSourceId(), source, game);
        }
        return true;
    }
}

