/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class KindredSummonsEffect
extends OneShotEffect {
    KindredSummonsEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Reveal cards from the top of your library until you reveal X creature cards of the chosen type, where X is the number of creatures you control of that type. Put those cards onto the battlefield, then shuffle the rest of the revealed cards into your library";
    }

    private KindredSummonsEffect(KindredSummonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public KindredSummonsEffect copy() {
        return new KindredSummonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
            if (subType == null) {
                return false;
            }
            FilterControlledCreaturePermanent filterPermanent = new FilterControlledCreaturePermanent("creature you control of the chosen type");
            filterPermanent.add((Predicate)subType.getPredicate());
            int numberOfCards = game.getBattlefield().countAll((FilterPermanent)filterPermanent, source.getControllerId(), game);
            CardsImpl revealed = new CardsImpl();
            LinkedHashSet<Card> chosenSubtypeCreatureCards = new LinkedHashSet<Card>();
            CardsImpl otherCards = new CardsImpl();
            FilterCreatureCard filterCard = new FilterCreatureCard("creature card of the chosen type");
            filterCard.add((Predicate)subType.getPredicate());
            if (numberOfCards == 0) {
                game.informPlayers("There are 0 creature cards of the chosen type in " + controller.getName() + "'s library.");
                return true;
            }
            for (Card card : controller.getLibrary().getCards(game)) {
                revealed.add(card);
                if (card != null && filterCard.match(card, game)) {
                    chosenSubtypeCreatureCards.add(card);
                    if (chosenSubtypeCreatureCards.size() != numberOfCards) continue;
                    break;
                }
                otherCards.add(card);
            }
            controller.revealCards(source, (Cards)revealed, game);
            controller.moveCards(chosenSubtypeCreatureCards, Zone.BATTLEFIELD, source, game);
            if (!otherCards.isEmpty()) {
                controller.putCardsOnTopOfLibrary((Cards)otherCards, game, source, false);
                controller.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

