/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class KioraPreventionEffect
extends PreventionEffectImpl {
    KioraPreventionEffect() {
        super(Duration.UntilYourNextTurn, Integer.MAX_VALUE, false, false);
        this.staticText = "Until your next turn, prevent all damage that would be dealt to and dealt by target permanent an opponent controls";
    }

    private KioraPreventionEffect(KioraPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public KioraPreventionEffect copy() {
        return new KioraPreventionEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.addInfo("kioraPrevention" + this.getId(), CardUtil.addToolTipMarkTags((String)"All damage that would be dealt to and dealt by this permanent is prevented."), game);
        }
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent targetPermanent;
        return super.applies(event, source, game) && event instanceof DamageEvent && (targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null && (event.getSourceId().equals(targetPermanent.getId()) || event.getTargetId().equals(targetPermanent.getId()));
    }

    public boolean isInactive(Ability source, Game game) {
        if (super.isInactive(source, game)) {
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                permanent.addInfo("kioraPrevention" + this.getId(), "", game);
            }
            return true;
        }
        return false;
    }
}

