/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.k.KjeldoranEliteGuardDelayedTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KjeldoranEliteGuardEffect
extends OneShotEffect {
    KjeldoranEliteGuardEffect() {
        super(Outcome.Neutral);
        this.staticText = "Target creature gets +2/+2 until end of turn. When that creature leaves the battlefield this turn, sacrifice {this}.";
    }

    public boolean apply(Game game, Ability source) {
        if (game.getPermanent(source.getFirstTarget()) == null) {
            return false;
        }
        BoostTargetEffect buffEffect = new BoostTargetEffect(2, 2, Duration.EndOfTurn);
        buffEffect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
        game.addEffect((ContinuousEffect)buffEffect, source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new KjeldoranEliteGuardDelayedTriggeredAbility(source.getFirstTarget()), source);
        return true;
    }

    private KjeldoranEliteGuardEffect(KjeldoranEliteGuardEffect effect) {
        super((OneShotEffect)effect);
    }

    public KjeldoranEliteGuardEffect copy() {
        return new KjeldoranEliteGuardEffect(this);
    }
}

