/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.k.KjeldoranGuardDelayedTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KjeldoranGuardEffect
extends OneShotEffect {
    KjeldoranGuardEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "target creature gets +1/+1 until end of turn. When that creature leaves the battlefield this turn, sacrifice {this}.";
    }

    private KjeldoranGuardEffect(KjeldoranGuardEffect effect) {
        super((OneShotEffect)effect);
    }

    public KjeldoranGuardEffect copy() {
        return new KjeldoranGuardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (targetPermanent == null) {
            return false;
        }
        BoostTargetEffect buffEffect = new BoostTargetEffect(1, 1, Duration.EndOfTurn);
        buffEffect.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent, game));
        game.addEffect((ContinuousEffect)buffEffect, source);
        KjeldoranGuardDelayedTriggeredAbility delayed = new KjeldoranGuardDelayedTriggeredAbility(new MageObjectReference((MageObject)targetPermanent, game));
        Permanent guard = source.getSourcePermanentIfItStillExists(game);
        if (guard != null) {
            delayed.getEffects().setTargetPointer((TargetPointer)new FixedTarget(guard, game));
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayed, source);
        return true;
    }
}

