/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mage.MageInt;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.k.KlauthUnrivaledAncientConditionalMana;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class KlauthUnrivaledAncientEffect
extends OneShotEffect {
    private static final List<String> manaSymbols = Arrays.asList("W", "U", "B", "R", "G");

    KlauthUnrivaledAncientEffect() {
        super(Outcome.Benefit);
        this.staticText = "add X mana in any combination of colors, where X is the total power of attacking creatures. Spend this mana only to cast spells. Until end of turn, you don't lose this mana as steps and phases end";
    }

    private KlauthUnrivaledAncientEffect(KlauthUnrivaledAncientEffect effect) {
        super((OneShotEffect)effect);
    }

    public KlauthUnrivaledAncientEffect copy() {
        return new KlauthUnrivaledAncientEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int attackerPower = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_ATTACKING_CREATURES, source.getControllerId(), source, game).stream().filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).sum();
        List manaList = player.getMultiAmount(this.outcome, manaSymbols, 0, attackerPower, attackerPower, MultiAmountType.MANA, game);
        player.getManaPool().addMana((Mana)new KlauthUnrivaledAncientConditionalMana(manaList), game, source, true);
        return true;
    }
}

