/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.MulticoloredPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KnightOfNewAlaraEffect
extends ContinuousEffectImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    public KnightOfNewAlaraEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Each other multicolored creature you control gets +1/+1 for each of its colors";
    }

    private KnightOfNewAlaraEffect(KnightOfNewAlaraEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public KnightOfNewAlaraEffect copy() {
        return new KnightOfNewAlaraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            if (creature == null || creature.getId().equals(source.getSourceId())) continue;
            int colors = creature.getColor(game).getColorCount();
            creature.addPower(colors);
            creature.addToughness(colors);
        }
        return true;
    }

    static {
        filter.add((Predicate)MulticoloredPredicate.instance);
    }
}

