/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class KnowledgeExploitationEffect
extends OneShotEffect {
    KnowledgeExploitationEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Search target opponent's library for an instant or sorcery card. You may cast that card without paying its mana cost. Then that player shuffles";
    }

    private KnowledgeExploitationEffect(KnowledgeExploitationEffect effect) {
        super((OneShotEffect)effect);
    }

    public KnowledgeExploitationEffect copy() {
        return new KnowledgeExploitationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
        controller.searchLibrary(target, source, game, opponent.getId());
        Card card = opponent.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
            controller.cast(controller.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        }
        opponent.shuffleLibrary(source, game);
        return true;
    }
}

