/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class KnowledgePoolExileThreeCardsEffect
extends OneShotEffect {
    KnowledgePoolExileThreeCardsEffect() {
        super(Outcome.Neutral);
        this.staticText = "each player exiles the top three cards of their library";
    }

    private KnowledgePoolExileThreeCardsEffect(KnowledgePoolExileThreeCardsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        MageObject sourceObject = game.getObject(source.getSourceId());
        if (sourceObject == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.moveCardsToExile(player.getLibrary().getTopCards(game, 3), source, game, true, CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC()), sourceObject.getIdName() + " (" + sourceObject.getZoneChangeCounter(game) + ')');
        }
        return true;
    }

    public KnowledgePoolExileThreeCardsEffect copy() {
        return new KnowledgePoolExileThreeCardsEffect(this);
    }
}

