/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KondasBannerTypeBoostEffect
extends BoostAllEffect {
    private static final String effectText = "Creatures that share a creature type with equipped creature get +1/+1";

    KondasBannerTypeBoostEffect() {
        super(1, 1, Duration.WhileOnBattlefield, StaticFilters.FILTER_PERMANENT_CREATURE, false);
        this.staticText = effectText;
    }

    private KondasBannerTypeBoostEffect(KondasBannerTypeBoostEffect effect) {
        super((BoostAllEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipedCreature;
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (equipedCreature = game.getPermanent(equipment.getAttachedTo())) != null) {
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (!perm.shareCreatureTypes(game, (MageObject)equipedCreature)) continue;
                perm.addPower(this.power.calculate(game, source, (Effect)this));
                perm.addToughness(this.toughness.calculate(game, source, (Effect)this));
            }
            return true;
        }
        return false;
    }

    public KondasBannerTypeBoostEffect copy() {
        return new KondasBannerTypeBoostEffect(this);
    }
}

