/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class KorvoldAndTheNobleThiefEffect
extends OneShotEffect {
    KorvoldAndTheNobleThiefEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top three cards of target opponent's library. You may play those cards this turn";
    }

    private KorvoldAndTheNobleThiefEffect(KorvoldAndTheNobleThiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public KorvoldAndTheNobleThiefEffect copy() {
        return new KorvoldAndTheNobleThiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        MageObject sourceObject = source.getSourceObject(game);
        if (player == null || opponent == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, 3));
        UUID exileId = CardUtil.getExileZoneId((String)(player.getId().toString() + "-" + game.getState().getTurnNum() + "-" + sourceObject.getIdName()), (Game)game);
        String exileName = sourceObject.getIdName() + " \u2014 T" + game.getState().getTurnNum() + " \u2014 Player: " + player.getName();
        game.getExile().createZone(exileId, exileName).setCleanupOnEndTurn(true);
        player.moveCardsToExile(cards.getCards(game), source, game, true, exileId, exileName);
        cards.retainZone(Zone.EXILED, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        }
        return true;
    }
}

