/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class KothophedSoulHoarderTriggeredAbility
extends TriggeredAbilityImpl {
    public KothophedSoulHoarderTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.setTriggerPhrase("Whenever a creature leaves an opponent's graveyard, ");
    }

    private KothophedSoulHoarderTriggeredAbility(KothophedSoulHoarderTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public KothophedSoulHoarderTriggeredAbility copy() {
        return new KothophedSoulHoarderTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() == Zone.GRAVEYARD && zEvent.getFromZone() == Zone.BATTLEFIELD) {
            Card card = game.getCard(zEvent.getTargetId());
            Player controller = game.getPlayer(this.getControllerId());
            return card != null && controller != null && controller.hasOpponent(card.getOwnerId(), game);
        }
        return false;
    }
}

