/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.k.KotoseTheSilentSpiderCondition;
import mage.cards.k.KotoseTheSilentSpiderWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class KotoseTheSilentSpiderEffect
extends OneShotEffect {
    KotoseTheSilentSpiderEffect() {
        super(Outcome.Exile);
        this.staticText = "exile target card other than a basic land card from an opponent's graveyard. Search that player's graveyard, hand, and library for any number of cards with the same name as that card and exile them. Then that player shuffles. For as long as you control {this}, you may play one of the exiled cards, and you may spend mana as though it were mana of any color to cast it";
    }

    private KotoseTheSilentSpiderEffect(KotoseTheSilentSpiderEffect effect) {
        super((OneShotEffect)effect);
    }

    public KotoseTheSilentSpiderEffect copy() {
        return new KotoseTheSilentSpiderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null) {
            return false;
        }
        Player opponent = game.getPlayer(card.getOwnerId());
        if (opponent == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source);
        String exileName = CardUtil.getSourceName((Game)game, (Ability)source);
        controller.moveCardsToExile(card, source, game, true, exileId, exileName);
        CardsImpl cards = new CardsImpl();
        FilterCard filter = new FilterCard("cards named " + card.getName() + " from " + opponent.getName() + "'s graveyard");
        filter.add((Predicate)new NamePredicate(card.getName()));
        TargetCardInGraveyard targetCardInGraveyard = new TargetCardInGraveyard(0, Integer.MAX_VALUE, filter);
        controller.choose(this.outcome, (Cards)opponent.getGraveyard(), (TargetCard)targetCardInGraveyard, source, game);
        cards.addAll((Collection)targetCardInGraveyard.getTargets());
        filter.setMessage("cards named " + card.getName() + " from " + opponent.getName() + "'s hand");
        TargetCard targetCard = new TargetCard(0, Integer.MAX_VALUE, Zone.HAND, filter);
        controller.choose(this.outcome, opponent.getHand(), targetCard, source, game);
        cards.addAll((Collection)targetCard.getTargets());
        filter.setMessage("cards named " + card.getName() + " from " + opponent.getName() + "'s library");
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, filter);
        controller.searchLibrary(target, source, game, opponent.getId());
        target.getTargets().stream().map(cardId -> opponent.getLibrary().getCard(cardId, game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        Set cardSet = cards.getCards(game);
        controller.moveCardsToExile(cardSet, source, game, true, exileId, exileName);
        opponent.shuffleLibrary(source, game);
        cardSet.add(card);
        if (cardSet.isEmpty() || source.getSourcePermanentIfItStillExists(game) == null) {
            return true;
        }
        KotoseTheSilentSpiderWatcher.addCards(source, cardSet, game);
        for (Card exiledCard : cardSet) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)exiledCard, (boolean)false, (Duration)Duration.WhileControlled, (boolean)true, null, (Condition)new KotoseTheSilentSpiderCondition(exiledCard, game));
        }
        return true;
    }
}

