/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class KrarkTheThumblessEffect
extends OneShotEffect {
    KrarkTheThumblessEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin. If you lose the flip, return that spell to its owner's hand. If you win the flip, copy that spell, and you may choose new targets for the copy";
    }

    private KrarkTheThumblessEffect(KrarkTheThumblessEffect effect) {
        super((OneShotEffect)effect);
    }

    public KrarkTheThumblessEffect copy() {
        return new KrarkTheThumblessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (player == null || spell == null) {
            return false;
        }
        if (player.flipCoin(source, game, true)) {
            spell.createCopyOnStack(game, source, player.getId(), true);
            return true;
        }
        if (spell.isCopy()) {
            game.getStack().remove((StackObject)spell, game);
            return true;
        }
        return game.getSpell(spell.getId()) != null && player.moveCards((Card)spell, Zone.HAND, source, game);
    }
}

