/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.RollDieEvent;

class KrarksOtherThumbEffect
extends ReplacementEffectImpl {
    KrarksOtherThumbEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if you would roll a die, instead roll two of those dice and ignore one of those results";
    }

    private KrarksOtherThumbEffect(KrarksOtherThumbEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        RollDieEvent rollDieEvent = (RollDieEvent)event;
        rollDieEvent.doubleRollsAmount();
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ROLL_DIE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public KrarksOtherThumbEffect copy() {
        return new KrarksOtherThumbEffect(this);
    }
}

