/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.SubTypeAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class KrosanVergeTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterCard("a Forest card and a Plains card");
    private static final SubTypeAssignment subTypeAssigner;

    KrosanVergeTarget() {
        super(0, 2, filter);
    }

    private KrosanVergeTarget(KrosanVergeTarget target) {
        super((TargetCardInLibrary)target);
    }

    public KrosanVergeTarget copy() {
        return new KrosanVergeTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return subTypeAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.FOREST.getPredicate(), (Predicate)SubType.PLAINS.getPredicate()));
        subTypeAssigner = new SubTypeAssignment(new SubType[]{SubType.FOREST, SubType.PLAINS});
    }
}

