/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class KroxaTitanOfDeathsHungerDiscardEffect
extends OneShotEffect {
    KroxaTitanOfDeathsHungerDiscardEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent discards a card, then each opponent who didn't discard a nonland card this way loses 3 life";
    }

    private KroxaTitanOfDeathsHungerDiscardEffect(KroxaTitanOfDeathsHungerDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public KroxaTitanOfDeathsHungerDiscardEffect copy() {
        return new KroxaTitanOfDeathsHungerDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards = new CardsImpl();
        game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).forEachOrdered(arg_0 -> KroxaTitanOfDeathsHungerDiscardEffect.lambda$apply$0(source, game, (Cards)cards, arg_0));
        HashSet playerSet = new HashSet();
        cards.getCards(game).stream().forEachOrdered(card -> {
            Player player = game.getPlayer(card.getOwnerId());
            if (player == null || !player.discard(card, false, source, game) || card.isLand(game)) {
                return;
            }
            playerSet.add(player.getId());
        });
        game.getOpponents(source.getControllerId(), true).stream().filter(uuid -> !playerSet.contains(uuid)).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).forEachOrdered(player -> player.loseLife(3, game, source, false));
        return true;
    }

    private static /* synthetic */ void lambda$apply$0(Ability source, Game game, Cards cards, Player player) {
        if (player.getHand().size() == 0) {
            return;
        }
        TargetCardInHand target = new TargetCardInHand(1, StaticFilters.FILTER_CARD);
        player.choose(Outcome.Discard, player.getHand(), (TargetCard)target, source, game);
        cards.add((Object)target.getFirstTarget());
    }
}

