/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetLandPermanent;

class KudzuEffect
extends OneShotEffect {
    KudzuEffect() {
        super(Outcome.Detriment);
        this.staticText = "destroy it. That land's controller may attach {this} to a land of their choice";
    }

    private KudzuEffect(KudzuEffect effect) {
        super((OneShotEffect)effect);
    }

    public KudzuEffect copy() {
        return new KudzuEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent kudzu = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (kudzu != null) {
            Permanent enchantedLand = game.getPermanentOrLKIBattlefield(kudzu.getAttachedTo());
            Player controller = game.getPlayer(source.getControllerId());
            if (enchantedLand != null && controller != null) {
                Player landsController = game.getPlayer(enchantedLand.getControllerId());
                if (game.getState().getZone(enchantedLand.getId()) == Zone.BATTLEFIELD) {
                    enchantedLand.destroy(source, game, false);
                }
                if (game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_LAND, source, game, 1)) {
                    Permanent landChosen;
                    TargetLandPermanent target = new TargetLandPermanent();
                    target.withNotTarget(true);
                    Card kudzuCard = game.getCard(source.getSourceId());
                    if (kudzuCard != null && landsController != null && landsController.choose(Outcome.Detriment, (Target)target, source, game) && target.getFirstTarget() != null && (landChosen = game.getPermanent(target.getFirstTarget())) != null) {
                        for (Target targetTest : kudzuCard.getSpellAbility().getTargets()) {
                            if (!targetTest.getFilter().match((Object)landChosen, game)) continue;
                            landChosen.addAttachment(kudzu.getId(), source, game);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }
}

