/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class KutzilsFlankerWatcher
extends Watcher {
    private final Map<UUID, Integer> mapCreaturesLeft = new HashMap<UUID, Integer>();

    KutzilsFlankerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() != Zone.BATTLEFIELD || !zEvent.getTarget().isCreature(game)) {
            return;
        }
        this.mapCreaturesLeft.compute(zEvent.getTarget().getControllerId(), CardUtil::setOrIncrementValue);
    }

    public void reset() {
        super.reset();
        this.mapCreaturesLeft.clear();
    }

    public static int getNumberCreatureLeft(UUID playerId, Game game) {
        KutzilsFlankerWatcher watcher = (KutzilsFlankerWatcher)game.getState().getWatcher(KutzilsFlankerWatcher.class);
        return watcher == null ? 0 : watcher.mapCreaturesLeft.getOrDefault(playerId, 0);
    }
}

