/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class KwainItinerantMeddlerEffect
extends OneShotEffect {
    KwainItinerantMeddlerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may draw a card, then each player who drew a card this way gains 1 life";
    }

    private KwainItinerantMeddlerEffect(KwainItinerantMeddlerEffect effect) {
        super((OneShotEffect)effect);
    }

    public KwainItinerantMeddlerEffect copy() {
        return new KwainItinerantMeddlerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<Player> players = new HashSet<Player>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.chooseUse(this.outcome, "Draw a card?", source, game) || player.drawCards(1, source, game) <= 0) continue;
            players.add(player);
        }
        for (Player player : players) {
            player.gainLife(1, game, source);
        }
        return !players.isEmpty();
    }
}

