/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class LaboratoryManiacEffect
extends ReplacementEffectImpl {
    LaboratoryManiacEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card while your library has no cards in it, you win the game instead";
    }

    private LaboratoryManiacEffect(LaboratoryManiacEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public LaboratoryManiacEffect copy() {
        return new LaboratoryManiacEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null) {
            player.won(game);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player player;
        return event.getPlayerId().equals(source.getControllerId()) && (player = game.getPlayer(event.getPlayerId())) != null && !player.hasLost() && !player.getLibrary().hasCards();
    }
}

