/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.BloodToken;

class LacerateFleshEffect
extends OneShotEffect {
    LacerateFleshEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 4 damage to target creature. Create a number of Blood tokens equal to the amount of excess damage dealt to that creature this way";
    }

    private LacerateFleshEffect(LacerateFleshEffect effect) {
        super((OneShotEffect)effect);
    }

    public LacerateFleshEffect copy() {
        return new LacerateFleshEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int excess = permanent.damageWithExcess(4, source, game);
        if (excess > 0) {
            new BloodToken().putOntoBattlefield(excess, game, source);
        }
        return true;
    }
}

